//AIM:To compute the Thermal noise,Signal to noise ratio and Shot noise power 
//for a PIN photodiode

//Software version Scilab 5.5.2
//OS Windows 7
clc;
clear;
//Consider responsivity 0.5 A/W,load resistance=2000 ohms,system 
//bandwidth=50MHz,temperature=40 degrees centigrade
//(a) Thermal noise :
T=40+273;//T=Temperature
disp('K',T,'T=')
delF=50*(10^3);//delF=Bandwidth
k=1.38*(10^-23);//k=Boltzmann constant
e=1.6*(10^-19);//E=Electron
RL=2000;//RL=Load resistance
//PNT=4*k*T*delF where PNT=Thermal noise
//If shot noise is equal to thermal noise,then PNT=PNS
//PNS is the shot noise power
//So, 4*k*T*delF=2*e*iS*delF*RL
//Hence iS=(2*k*T)/(e*RL)
iS=(2*k*T)/(e*RL);//iS=signal photocurrent
disp('Amp',iS,'iS=')
R=0.5;//R=responsivity=0.5
PR=iS/R;
disp('Watts',PR,'Received optic power PR=');
PNT=4*k*T*delF;
disp(PNT,'Thermal noise PNT=')

//(b) Signal to noise ratio:
//Since PNS=PNT;
//Total noise;N=PNS+PNT
//So,N=2*PNS
//But PNS=2*e*iS*delF*RL
S_by_N=(iS)/(4*e*delF);
disp(S_by_N,'Signal to noise ratio (S/N)=')

//(c) Shot noise power:
PNS=2*e*iS*delF*RL;
disp('Watts',PNS,'Shot noise power PNS=')
